<?php
session_start();
require_once("../config.php");

// ✅ Ensure user is logged in
if (!isset($_SESSION['SESS_LOGGEDIN']) || $_SESSION['SESS_LOGGEDIN'] !== true) {
    header("Location: " . $config_basedir . "logout.php");
    exit();
}

$user_id   = $_SESSION['SESS_USERID'];
$user_email = $_SESSION['SESS_EMAIL'];
$user_name = $_SESSION['SESS_NAME'] ?? 'User';

try {
    // ✅ Fetch last transaction for this user
    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE email = :email ORDER BY id DESC LIMIT 1");
    $stmt->execute([':email' => $user_email]);
    $txn = $stmt->fetch(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Successful Transfer</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #f8f9fa;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
}
.success-box {
    background: white;
    border-radius: 20px;
    padding: 40px 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    max-width: 400px;
    text-align: center;
}
.success-title {
    background: linear-gradient(to right, #007bff, #3f7efc);
    color: white;
    border-radius: 8px;
    padding: 10px;
    font-weight: bold;
    font-size: 1.1rem;
}
.success-icon {
    font-size: 60px;
    color: #28a745;
    margin: 20px 0;
}
.amount {
    font-size: 1.5rem;
    font-weight: bold;
    color: #003366;
}
.beneficiary {
    color: #007b00;
    font-weight: 600;
}
.btn-receipt {
    margin-top: 25px;
    border-radius: 10px;
    padding: 10px 20px;
}
</style>
</head>
<body>

<div class="success-box">
    <div class="success-title">SUCCESSFUL TRANSFER</div>
    <div class="mt-3">
        <h4 class="fw-bold text-dark">
            Payment completed <span class="success-icon">✔️</span>
        </h4>
        <p>Thank you for your transfer</p>
        <div class="amount">
            <?= htmlspecialchars($txn['cur']) ?> <?= number_format($txn['trans_amount'], 2) ?>
        </div>
        <p class="mt-3 beneficiary">
            You have successfully transferred to <?= htmlspecialchars($txn['ben_name']) ?> of <?= htmlspecialchars($txn['bank_name']) ?>
        </p>

        <button class="btn btn-primary btn-receipt" data-bs-toggle="modal" data-bs-target="#receiptModal">
            View Receipt
        </button>
    </div>
</div>

<!-- Receipt Modal -->
<div class="modal fade" id="receiptModal" tabindex="-1" aria-labelledby="receiptModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Transaction Receipt</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <table class="table table-borderless">
            <tr><th>Date</th><td><?= htmlspecialchars($txn['date']) ?></td></tr>
            <tr><th>Amount</th><td><?= htmlspecialchars($txn['cur']) . ' ' . number_format($txn['trans_amount'], 2) ?></td></tr>
            <tr><th>Status</th><td><span class="text-success fw-bold">Successful</span></td></tr>
            <tr><th>Beneficiary</th><td><?= htmlspecialchars($txn['ben_name']) ?></td></tr>
            <tr><th>Account Number</th><td><?= htmlspecialchars($txn['ben_acct_no']) ?></td></tr>
            <tr><th>Bank</th><td><?= htmlspecialchars($txn['bank_name']) ?></td></tr>
            <tr><th>Reference</th><td><?= htmlspecialchars($txn['trans_id']) ?></td></tr>
            <tr><th>Note</th><td><?= htmlspecialchars($txn['note']) ?></td></tr>
        </table>
      </div>
      <div class="modal-footer">
        <a href="dashboard.php" class="btn btn-secondary">Close</a>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
