  <?php

require_once("header.php");
?>


<?php
require '../config.php'; // Make sure PDO $pdo is configured

// Enable error reporting for debug
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Get ID
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    die("Invalid ID");
}

// Fetch existing settings
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ordrow) {
    die("No settings found for ID $id");
}



// ✅ Handle form submission
if (isset($_POST['action'])) {
    $bank_name  = trim($_POST['bank_name']);
    $bank_addr  = trim($_POST['bank_addr']);
    $acc_name   = trim($_POST['acc_name']);
    $acc_numb   = trim($_POST['acc_numb']);
    $swift_iban = trim($_POST['swift_iban']);
    $routin_numb= trim($_POST['routin_numb']);
    $btc_rate   = trim($_POST['btc_rate']);
    $btc_addr   = trim($_POST['btc_addr']);

    try {
        $update = $pdo->prepare("
            UPDATE settings 
            SET bank_name = :bank_name,
                bank_addr = :bank_addr,
                acc_name = :acc_name,
                acc_numb = :acc_numb,
                swift_iban = :swift_iban,
                routin_numb = :routin_numb,
                btc_rate = :btc_rate,
                btc_addr = :btc_addr
            WHERE id = :id
        ");

        $update->execute([
            ':bank_name' => $bank_name,
            ':bank_addr' => $bank_addr,
            ':acc_name' => $acc_name,
            ':acc_numb' => $acc_numb,
            ':swift_iban' => $swift_iban,
            ':routin_numb' => $routin_numb,
            ':btc_rate' => $btc_rate,
            ':btc_addr' => $btc_addr,
            ':id' => $id
        ]);

        $success = "
            <center>
                <div class='warning' style='margin-bottom:50px;'>
                    <div class='loader'></div>
                    Uploading Information...
                    <meta http-equiv='refresh' content='5; url=' />
                    Please wait......
                </div>
            </center>
        ";
    } catch (PDOException $e) {
        die("Update failed: " . $e->getMessage());
    }
}

// Fetch latest data after update
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = 1");
$stmt->execute();
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class='page-wrapper'>
    <div class='page-breadcrumb'>
        <div class='row'>
            <div class='col-12 d-flex no-block align-items-center'>
                <h5>BANK DETAILS</h5>
            </div>
        </div>
    </div>

    <div class='container-fluid'>
        <div class='row'>
            <div class='col-12'>
                <div class='card'>
                    <div class='content-wrapper'>
                        <section class='content'>
                            <div class='row'>
                                <div class='col-md-12'>
                                    <div class='nav-tabs-custom'>
                                        <div class='tab-content'>
                                            <div class='active tab-pane' id='activity'>
                                                <div class='post'>
                                                    <section class='content'>
                                                        <div class='row'>
                                                            <div class='box box-success'>
                                                                <div class='box-body'>
                                                                    <div class='table-responsive'>
                                                                        <div class='box-body'>
                                                                            <div class='container'>

                                                                                <?php 
                                                                                if (isset($success)) {
                                                                                    echo $success;
                                                                                }
                                                                                ?>

                                                                                <form class='form-horizontal' method='post' enctype='multipart/form-data' action=''>
                                                                                    <hr>
                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>ACCOUNT NUMBER</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='acc_numb' type='number' class='form-control' value='<?= htmlspecialchars($ordrow['acc_numb']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>ACCOUNT OFFICER NAME</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='acc_name' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['acc_name']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>BANK NAME</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='bank_name' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['bank_name']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>BANK ADDRESS</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='bank_addr' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['bank_addr']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>SWIFT IBAN</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='swift_iban' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['swift_iban']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>ROUTIN NUMBER</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='routin_numb' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['routin_numb']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>BTC ADDRESS</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='btc_addr' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['btc_addr']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class='form-group'>
                                                                                        <label class='col-sm-2 control-label' style='color:#009900'>BTC RATE</label>
                                                                                        <div class='col-sm-10'>
                                                                                            <input name='btc_rate' type='text' class='form-control' value='<?= htmlspecialchars($ordrow['btc_rate']) ?>'>
                                                                                        </div>
                                                                                    </div>

                                                                                    <center>
                                                                                        <button type='submit' class='btn btn-info btn-flat' name='action'>
                                                                                            <i class='fa fa-save'></i>&nbsp;Update Bank
                                                                                        </button>
                                                                                    </center>
                                                                                </form>

                                                                            </div><!-- container -->
                                                                        </div><!-- box-body -->
                                                                    </div><!-- table-responsive -->
                                                                </div><!-- box-body -->
                                                            </div><!-- box -->
                                                        </div><!-- row -->
                                                    </section>
                                                </div><!-- post -->
                                            </div><!-- tab-pane -->
                                        </div><!-- tab-content -->
                                    </div><!-- nav-tabs-custom -->
                                </div><!-- col -->
                            </div><!-- row -->
                        </section><!-- content -->
                    </div><!-- content-wrapper -->
                </div><!-- card -->
            </div><!-- col -->
        </div><!-- row -->
    </div><!-- container-fluid -->
</div><!-- page-wrapper -->

<?php require("footer.php"); ?>

<script>
function myFunction() {
  window.print();
}
</script>
