  <?php

require_once("header.php");
?>


<?php
require '../config.php'; // Make sure PDO $pdo is configured

// Enable error reporting for debug
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Get ID
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    die("Invalid ID");
}

// Fetch existing settings
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ordrow) {
    die("No settings found for ID $id");
}





if (isset($_POST['action'])) {
    $id = $_GET['id'] ?? null;

    if ($id && is_numeric($id)) {
        // Prepare data safely
        $fields = ['GHS', 'EUR', 'NGN', 'CAD', 'GBP', 'ZAR', 'JPY', 'CNY', 'USD', 'AUD', 'KRW', 'TWD', 'THB', 'MYR', 'BRL', 'ARS', 'PHP', 'AED'];
        $updateData = [];

        foreach ($fields as $field) {
            $updateData[$field] = $_POST[$field] ?? '';
        }

        try {
            $sql = "UPDATE settings SET 
                GHS = :GHS,
                EUR = :EUR,
                NGN = :NGN,
                CAD = :CAD,
                GBP = :GBP,
                ZAR = :ZAR,
                JPY = :JPY,
                CNY = :CNY,
                USD = :USD,
                AUD = :AUD,
                KRW = :KRW,
                TWD = :TWD,
                THB = :THB,
                MYR = :MYR,
                BRL = :BRL,
                ARS = :ARS,
                PHP = :PHP,
                AED = :AED
                WHERE id = :id";

            $stmt = $pdo->prepare($sql);

            // Bind parameters
            foreach ($updateData as $key => $value) {
                $stmt->bindValue(":$key", $value);
            }
            $stmt->bindValue(':id', $id, PDO::PARAM_INT);

            $stmt->execute();

            echo "<script>alert('Currency updated successfully!'); window.location.href='';</script>";
        } catch (PDOException $e) {
            echo "<script>alert('Update failed: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>alert('Invalid ID provided.');</script>";
    }
}
?>


<!--===========================================-->

   
   	

 <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Bread crumb and right sidebar toggle -->
            <!-- ============================================================== -->
          
            
            
           <?php 
if(isset($success)){
    echo $success;
}
?>
             
                                              
                                               
                           
                           
                 <div class="container" align="center">
 <div id="blog-left" style="padding:50px">

    <div class="contact-form">
        <div class="blog-comment-form" style="padding:0px">
          
           <center>
     <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center">
                        <h4 class="page-title">ADMIN UPDATE CURRENCY CONVERTION RATING</h4>
                        <div class="ml-auto text-right">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page" href="index.php">HOME</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
    </center>
          
          <br>
          
        <form action="" method="post">
    <?php
    // Currency list with their corresponding symbols and labels
    $currencies = [
        'USD' => 'USD AMERICA &#36; (DEFAULT)',
        'GBP' => 'GBP BRITISH &#163;',
        'EUR' => 'EUR EUROPE &#8364;',
        'AUD' => 'AUD AUSTRALIA &#8371;',
        'CAD' => 'CAD CANADA &#36;',
        'CNY' => 'CNY CHINESE &#165;',
        'ZAR' => 'ZAR SOUTH AFRICA &#82;',
        'NGN' => 'NGN NIGERIA &#8358;',
        'GHS' => 'GHS GHANA &#8373;',
        'JPY' => 'JPY JAPAN &#165;',
        'KRW' => 'KRW SOUTH KOREA &#8361;',
        'TWD' => 'TWD TAIWAN &#78;',
        'THB' => 'THB THAILAND &#3647;',
        'MYR' => 'MYR MALAYSIA &#77;',
        'BRL' => 'BRL BRAZIL &#82;',
        'ARS' => 'ARS ARGENTINA &#36;',
        'PHP' => 'PHP PHILIPPINES &#8369;',
        'AED' => 'AED EMIRATE &#x625;'
    ];

    // Loop through each currency field to generate the form inputs
    foreach ($currencies as $code => $label) {
        $value = htmlspecialchars($ordrow[$code] ?? '', ENT_QUOTES, 'UTF-8');
        $readonly = $code === 'USD' ? 'readonly' : '';
        echo <<<HTML
        <div>
            <label for="{$code}">{$label}</label><br>
            <input class="form-control" type="text" name="{$code}" id="{$code}" value="{$value}" {$readonly}><br><br>
        </div>
        HTML;
    }
    ?>

    <button type="submit" class="btn btn-success" name="action">UPDATE CURRENCY</button>
</form>

        </div></div></div>
</div>          
                           
                           
                           
                           
                           
                             
                             
                            
                        </div>
                       
                       
                       
                       
                       
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
            </div>
           
           
           <script type="text/javascript">
    function readTextFile(file, callback, encoding) {
   var reader = new FileReader();
   reader.addEventListener('load', function (e) {
    callback(this.result);
   });
   if (encoding) reader.readAsText(file, encoding);
   else reader.readAsText(file);
  }

  function fileChosen(input, output) {
   if (input.files && input.files[0]) {
    readTextFile(
     input.files[0],
     function (str) {
      output.value = str;
     }
    );
   }
  }

  $('#files').on('change', function () {
  var result = $("#files").text();
   
   fileChosen(this, document.getElementById('editor1'));
   CKEDITOR.instances['editor1'].setData(result);
  });
  </script>
      
      
      
      
       <script type="text/javascript">
    function readTextFile(file, callback, encoding) {
   var reader = new FileReader();
   reader.addEventListener('load', function (e) {
    callback(this.result);
   });
   if (encoding) reader.readAsText(file, encoding);
   else reader.readAsText(file);
  }

  function fileChosen(input, output) {
   if (input.files && input.files[0]) {
    readTextFile(
     input.files[0],
     function (str) {
      output.value = str;
     }
    );
   }
  }

  $('#files').on('change', function () {
  var result = $("#files").text();
   
   fileChosen(this, document.getElementById('editor2'));
   CKEDITOR.instances['editor2'].setData(result);
  });
  </script>
  
  
   <script type="text/javascript">
    function readTextFile(file, callback, encoding) {
   var reader = new FileReader();
   reader.addEventListener('load', function (e) {
    callback(this.result);
   });
   if (encoding) reader.readAsText(file, encoding);
   else reader.readAsText(file);
  }

  function fileChosen(input, output) {
   if (input.files && input.files[0]) {
    readTextFile(
     input.files[0],
     function (str) {
      output.value = str;
     }
    );
   }
  }

  $('#files').on('change', function () {
  var result = $("#files").text();
   
   fileChosen(this, document.getElementById('editor3'));
   CKEDITOR.instances['editor3'].setData(result);
  });
  </script>
           
           
           
           
           
           
           
           
             <script type="text/javascript">
    function readTextFile(file, callback, encoding) {
   var reader = new FileReader();
   reader.addEventListener('load', function (e) {
    callback(this.result);
   });
   if (encoding) reader.readAsText(file, encoding);
   else reader.readAsText(file);
  }

  function fileChosen(input, output) {
   if (input.files && input.files[0]) {
    readTextFile(
     input.files[0],
     function (str) {
      output.value = str;
     }
    );
   }
  }

  $('#files').on('change', function () {
  var result = $("#files").text();
   
   fileChosen(this, document.getElementById('editor4'));
   CKEDITOR.instances['editor4'].setData(result);
  });
  </script>
          
           <?php require ("footer.php")?>