  <?php require ("header.php")?>
  
<?php
require_once '../config.php'; // DB connection

function validate_id($value, $redirectUrl) {
    if (!isset($value) || !is_numeric($value)) {
        header("Location: $redirectUrl");
        exit;
    }
    return (int) $value;
}

// Delete logic
if (isset($_GET['delete_id'])) {
    $id = validate_id($_GET['delete_id'], 'outbox.php');

    $stmt = $pdo->prepare("DELETE FROM message WHERE id = :id");
    $stmt->execute([':id' => $id]);

    // Force redirect to index.php after deletion
    echo "<script>
        alert('Message deleted successfully.');
        window.location.href = 'index.php';
    </script>";
    exit;
}
?>

<!-- HTML Section -->
<div class="page-wrapper">
    <div class="page-breadcrumb">
        <div class="row">
            <div class="col-12 d-flex no-block align-items-center">
                <h4 class="page-title">
                    OUTBOX MAILS (
                    <?php
                    $stmt = $pdo->query("SELECT COUNT(id) AS total FROM message WHERE status = 1");
                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                    echo $row['total'];
                    ?>
                    )
                </h4>
                <div class="ml-auto text-right">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Outbox</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class='container-fluid'>
        <div class='row justify-content-center'>
            <div class='col-md-10'>
                <div class='card'>
                    <div class='card-body'>
                        <h4 class='card-title m-b-0'>Recent Posts</h4>
                    </div>
                    <div class='comment-widgets scrollable'>

                        <?php
                        $sql = "SELECT * FROM message ORDER BY id DESC";
                        $stmt = $pdo->query($sql);
                        $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        foreach ($messages as $row) {
                            if ($row['status'] == 1) {
                                echo "<div class='d-flex flex-row comment-row m-t-0'>
                                        <div class='p-2'>";
                                
                                if ($row['photo'] == 0) {
                                    echo "<img src='../accounts/upload/photo/default.png' class='rounded-circle' style='width:50px;height:50px'>";
                                } elseif ($row['photo'] == 1 && !empty($row['P_location'])) {
                                    echo "<img src='../" . htmlspecialchars($row['P_location']) . "' class='rounded-circle' style='width:50px;height:50px'>";
                                }

                                echo "</div>
                                    <div class='comment-text w-100' style='text-align: left; font-size: 16px;'>
                                        <h6 class='font-medium'>" . htmlspecialchars($row['name']) . "</h6>
                                        <span class='m-b-15 d-block'>" . nl2br(htmlspecialchars($row['msg'])) . "</span>
                                        <div class='comment-footer'>
                                            <span class='btn btn-success btn-sm float-right'>" . htmlspecialchars($row['date']) . "</span>
                                            <a class='btn btn-info btn-sm' href='reply_outbox.php?id=" . $row['id'] . "'>View</a>
                                            <a class='btn btn-success btn-sm' href='reply_outbox.php?id=" . $row['id'] . "'>Reply</a>
                                            <a href='#' class='btn btn-danger btn-sm' onclick='confirmDelete(" . $row['id'] . "); return false;'>Delete</a>
                                        </div>
                                    </div>
                                </div>";
                            }
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Confirm Delete Script -->
<script>
function confirmDelete(id) {
    if (confirm("Are you sure you want to delete this message?")) {
        // Redirect to same page with delete request
        window.location.href = "outbox.php?delete_id=" + id;
    }
}
</script>


             <?php require ("footer.php")?>